#include "sound.h"
#include "game.h"
#include <string.h>

// External soundbank for audio data
extern u8 soundbank_bin[];

// Sound effect definitions with default settings
mm_sound_effect sfx_exit = {{SFX_EXIT}, (int)(1.0f * (1<<10)), 0, 255, 128};
mm_sound_effect sfx_coin = {{SFX_COIN}, (int)(1.0f * (1<<10)), 0, 255, 128};
mm_sound_effect sfx_berry = {{SFX_BERRY}, (int)(1.0f * (1<<10)), 0, 255, 128};
mm_sound_effect sfx_pokeball = {{SFX_POKEBALL}, (int)(1.0f * (1<<10)), 0, 255, 128};
mm_sound_effect sfx_pipe = {{SFX_PIPE}, (int)(1.0f * (1<<10)), 0, 255, 128};
mm_sound_effect sfx_wall = {{SFX_WALL}, (int)(1.0f * (1<<10)), 0, 255, 128};
mm_sound_effect sfx_player = {{SFX_PLAYER}, (int)(1.0f * (1<<10)), 0, 255, 100};
mm_sound_effect sfx_spawn = {{SFX_SPAWN}, (int)(1.0f * (1<<10)), 0, 255, 160};
mm_sound_effect sfx_ramp = {{SFX_RAMP}, (int)(1.0f * (1<<10)), 0, 255, 128};
mm_sound_effect sfx_stop = {{SFX_STOP}, (int)(1.0f * (1<<10)), 0, 255, 128};
mm_sound_effect sfx_warp = {{SFX_WARP}, (int)(1.0f * (1<<10)), 0, 255, 128};
mm_sound_effect sfx_start = {{SFX_START}, (int)(1.0f * (1<<10)), 0, 255, 128};
mm_sound_effect sfx_jiggly = {{SFX_JIGGLY}, (int)(1.0f * (1<<10)), 0, 255, 64};
mm_sound_effect sfx_kiss = {{SFX_KISS}, (int)(1.0f * (1<<10)), 0, 255, 192};
mm_sound_effect sfx_happy = {{SFX_HAPPY}, (int)(1.0f * (1<<10)), 0, 255, 192};
mm_sound_effect sfx_electro = {{SFX_ELECTRO}, (int)(1.0f * (1<<10)), 0, 255, 64};
mm_sound_effect sfx_explode = {{SFX_EXPLODE}, (int)(1.0f * (1<<10)), 0, 255, 128};
mm_sound_effect sfx_switch = {{SFX_SWITCH}, (int)(1.0f * (1<<10)), 0, 255, 128};
mm_sound_effect sfx_special1 = {{SFX_SPECIAL1}, (int)(1.0f * (1<<10)), 0, 255, 128};
mm_sound_effect sfx_special2 = {{SFX_SPECIAL2}, (int)(1.0f * (1<<10)), 0, 255, 128};

// Initialize sound system with MaxMod
void initSound(void) {
    irqInit();
    irqSet(IRQ_VBLANK, mmVBlank);
    irqEnable(IRQ_VBLANK);
    mmInitDefault((mm_addr)soundbank_bin, 8);
}

// Play background music based on world type or track name
void playMusic(const char* track, WorldType worldType) {
    mm_pmode playMode = MM_PLAY_LOOP;

    if (track == NULL || strcmp(track, "") == 0) {
        switch (worldType) {
            case WORLD_LAB:
                mmStart(MOD_MUSIC_LAB, playMode);
                break;
            case WORLD_ICE:
                mmStart(MOD_MUSIC_ICE, playMode);
                break;
            case WORLD_POWERP:
                mmStart(MOD_MUSIC_POWERP, playMode);
                break;
            case WORLD_CAVE:
                mmStart(MOD_MUSIC_CAVE, playMode);
                break;
            case WORLD_MANSION:
                mmStart(MOD_MUSIC_MANSION, playMode);
                break;
            case WORLD_WOODS:
                mmStart(MOD_MUSIC_WOODS, playMode);
                break;
            case WORLD_CITY:
                mmStart(MOD_MUSIC_CITY, playMode);
                break;
            case WORLD_SPECIAL1:
                mmStart(MOD_MUSIC_SPECIAL1, playMode);
                break;
            case WORLD_SPECIAL2:
                mmStart(MOD_MUSIC_SPECIAL2, playMode);
                break;
            default:
                mmStart(MOD_MUSIC_LAB, playMode);
                break;
        }
    } else if (strcmp(track, "ICE") == 0) {
        mmStart(MOD_MUSIC_ICE, playMode);
    } else if (strcmp(track, "LAB") == 0) {
        mmStart(MOD_MUSIC_LAB, playMode);
    } else if (strcmp(track, "CAVE") == 0) {
        mmStart(MOD_MUSIC_CAVE, playMode);
    } else if (strcmp(track, "CITY") == 0) {
        mmStart(MOD_MUSIC_CITY, playMode);
    } else if (strcmp(track, "MANSION") == 0) {
        mmStart(MOD_MUSIC_MANSION, playMode);
    } else if (strcmp(track, "POWERP") == 0) {
        mmStart(MOD_MUSIC_POWERP, playMode);
    } else if (strcmp(track, "WOODS") == 0) {
        mmStart(MOD_MUSIC_WOODS, playMode);
    } else if (strcmp(track, "SPECIAL1") == 0) {
        mmStart(MOD_MUSIC_SPECIAL1, playMode);
    } else if (strcmp(track, "SPECIAL2") == 0) {
        mmStart(MOD_MUSIC_SPECIAL2, playMode);
    } else {
        mmStart(MOD_MUSIC_LAB, playMode);
    }

    mmSetModuleVolume(512);
    mmSetEffectsVolume(1024);
}